<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "../config.php";
require_once "../getRegionList.php";
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required"; 
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
$empId = htmlspecialchars(strip_tags($data["empId"]));

$response = array();
$productCatlogArray = array(); 

if (!empty($empId)) {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $regionId = htmlspecialchars(strip_tags($data["empRegionId"]));

    $pageSize = 100;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId'";
    $query1 = mysqli_query($con,$sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
   
    $row = getRegionList($region);
 
    $sql = "SELECT * 
            FROM
            tbl_productcatlog 
            WHERE 
            status=1
            ORDER BY 
            `id` DESC
            LIMIT
            $limitFrom, $pageSize";
            
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                $pdf = $row['pdf_path'];

                if($row['type']=="1"){
                    $path = $pdf;
                }else{
                   $path="https://gaplconnect.com/Multimedia/".$pdf;
                }
                if($row['type']==1){
                    $typeName = 'Video';
                }else if($row['type']==2){
                    $typeName = 'Audio';
                }else if($row['type']==3){
                    $typeName = 'PDF';
                }
                array_push(
                    $productCatlogArray,
                    array(
                        "id" => $row['id'],
                        "name" => $row["name"],
                        "path" => $path,
                        "disc" => $row["description"],
                        "type" => $row["type"], 
                        "typeName" => $typeName, 
                        "date" => $row["date"]
                    )
                );      
                
            }
            $response['listCount'] = $rowCount;
            $response['productCatlogList'] = $productCatlogArray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);