<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "../config.php";
require_once "../getRegionList.php";
require_once "functions.php";
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required"; 
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
$empId = htmlspecialchars(strip_tags($data["empId"]));
$testId = htmlspecialchars(strip_tags($data["testId"]));
$productValArry = getAllProductsName('All');
$cropValArry = getAllCropName('All');
$response = array();
$Testiarray = array();
$Farmerarray = array();

if (!empty($testId)) {
    $testId = htmlspecialchars(strip_tags($data["testId"]));

    $sql = "SELECT * 
            FROM 
            `tbl_testimonial` t1
            LEFT JOIN
            `tbl_testimonial_type` t2
            ON
            t1.testMeetingTypeId = t2.testimonial_type_id
            LEFT JOIN
            `tbl_employee` t3 
            ON
            t3.id = t1.empId
            WHERE 
            `testId` = '$testId'";
            
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                
                if ($row['testCustTypeId'] == '1') {
                    $sql12 = "SELECT * FROM `tbl_farmer` WHERE `farmerId`='" . $row['customerId'] . "'";
                    $query12 = mysqli_query($con,$sql12);
                    $row12 = mysqli_fetch_array($query12);

                    $customerName = $row12['farmerName'];
                    $customerMobile = $row12['farmerMobile'];
                    $VillageName = $row12['farmerCity'];
                } else if ($row['testCustTypeId'] == '2' || $row['testCustTypeId'] == '3') {

                    $sql13 = "SELECT * FROM `tbl_agency` WHERE `agencyId`='" . $row['customerId'] . "'";
                    $query13 = mysqli_query($con,$sql13);
                    $row13 =  mysqli_fetch_array($query13);

                    $customerName = $row13['agencyShopName'];
                    $customerMobile = $row13['agencyMobile'];
                    $VillageName = $row13['agencyCity'];
                }

                if($row['productId']){
                    $key = '';
                    $key = array_search($row['productId'], array_column($productValArry, 'pid'));
                    if ($key === FALSE) {
                        $productName = '';
                    } else {
                        $productName = $productValArry[$key]['productName'];
                    }
                }
                
                if($row['cropId']){
                    $key = '';
                    $key = array_search($row['cropId'], array_column($cropValArry, 'cropId'));
                    if ($key === FALSE) {
                        $cropName = '';
                    } else {
                        $cropName = $cropValArry[$key]['cropName'];
                    }
                }
                    
                array_push($Testiarray, array(
                    "testId" => $row['testId'],
                    "type" => $row['testimonial_type_name'],
                    "cropId" => $row['cropId'],
                    "cropName" => $cropName,
                    "productId" => $row['productId'],
                    "productName" => $productName,
                    "customerId" => $row['customerId'],
                    "customerName" => $customerName,
                    "customermobile" => $customerMobile,
                    "villageName" => $VillageName,
                    "datofSowing" => $row['datofSowing'],
                    "dateOfSpray" => $row['dateOfSpray'],
                    "empId" => $row['empId'],
                    "empName" => $row['emp_name'],
                    "testPhoto" => $row['testPhoto'],
                    "testVdo" => $row['testVdo'],
                    "testMeetingTypeId" => $row['testMeetingTypeId'],
                    "testCustTypeId" => $row['testCustTypeId'],
                    "accompainedBy" => $row['accompainedBy'],
                    "testRemark" => $row['testRemark'],
                    "regionId" => $row['regionId'],
                    "activity_time" => $row['activity_time'],
                    "date" => $row['testDate']
                ));
               
            }
            $response['listCount'] = $rowCount;
            $response['testimonialList'] = $Testiarray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);