<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "../config.php";
require_once "../getRegionList.php";
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required"; 
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
$empId = htmlspecialchars(strip_tags($data["empId"]));

$response = array();
$revisitarray = array();
$Farmerarray = array();

if (!empty($empId)) {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $empId = htmlspecialchars(strip_tags($data["empId"]));

    $pageSize = 10;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId'";
    $query1 = mysqli_query($con,$sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
   
    $row = getRegionList($region);
 
    $sql = "SELECT * 
            FROM 
            `tbl_revisit` 
            LEFT JOIN 
            `tbl_farmer` 
            ON 
            `tbl_farmer`.`farmerId` = `tbl_revisit`.`farmerId` 
            LEFT JOIN
            `tbl_category`
            ON 
            `tbl_category`.`category_id` = `tbl_farmer`.`farmerRegion`
            WHERE 
            `tbl_farmer`.`farmerRegion` IN ($row) 
            ORDER BY 
            `rid` DESC
            LIMIT
            $limitFrom, $pageSize";
            
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                
           	    array_push($revisitarray,array( 
				    "revisitId" => $row["rid"],
					"farmerId" => $row["farmerId"],
					"farmerName" => $row["farmerName"],
					"farmerMobile" => $row["farmerMobile"],
					"farmerLandAcerage" => $row["farmerLandAcerage"],
					"farmerRegion" => $row["category_name"],
                    "revistPurpose" => $row["revisitPurpose"],
                    "photo" => $row["photo"],
                    "revisit_date_time" => $row["revisit_datetime"]
					)
				);
               
            }
            $response['listCount'] = $rowCount;
            $response['revisitList'] = $revisitarray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);