<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "../config.php";
require_once "../getRegionList.php";
require_once "functions.php";
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required"; 
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
// print_r($data);
$empId = htmlspecialchars(strip_tags($data["empId"]));

$response = array();
$agencyArray = array();
$getAgencyNameVal = getAgencyNameArray();  
$getCompanyCompititorsNameVal = getCompanyCompetitorName(); 
if (!empty($empId)) {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $empId = htmlspecialchars(strip_tags($data["empId"]));
    $agencyType = htmlspecialchars(strip_tags($data["agencyType"]));

    $pageSize = 100;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId'";
    $query1 = mysqli_query($con,$sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
   
    $row = getRegionList($region);
 
    $sql = "SELECT * 
            FROM 
            `tbl_agency` 
            LEFT JOIN 
            `tbl_category` 
            ON 
            `tbl_category`.category_id = `tbl_agency`.agencyRegion 
            WHERE 
            `tbl_agency`.`agencyRegion` IN ($row) 
            AND 
            `tbl_agency`.`agencyType` = '$agencyType'
            ORDER BY 
            `tbl_agency`.`agencyId` DESC
            LIMIT
            $limitFrom, $pageSize";
            
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                
                array_push(
                    $agencyArray,
                    array(
                        "agencyId" => htmlspecialchars(strip_tags($row["agencyId"])),
                        "agencyShopName" => htmlspecialchars(strip_tags($row["agencyShopName"])),
                        "agencyName" => htmlspecialchars(strip_tags($row["agencyName"])),
                        "agencyMobile" => htmlspecialchars(strip_tags($row["agencyMobile"])),
                        "regionName" => htmlspecialchars(strip_tags($row["category_name"])),
                        "agencyRegion" => htmlspecialchars(strip_tags($row["agencyRegion"])),
                        "agencyType" => htmlspecialchars(strip_tags($row["agencyType"]))
                    )
                );
                
            }
            $response['listCount'] = $rowCount;
            $response['agencyList'] = $agencyArray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);