<?php 
function getRegionId($id){ 
    global $con;
    $count = 0;
    $row = "";
    $regionId = $id;
    $sql ="WITH RECURSIVE mainCat AS (
        SELECT category_id, category_name, parent_category_id FROM tbl_category 
        WHERE 
        parent_category_id = $regionId 
        UNION ALL 
        SELECT e.category_id,e.category_name, e.parent_category_id 
        FROM 
        tbl_category e 
        INNER JOIN mainCat m ON e.parent_category_id = m.category_id ) 
        SELECT * FROM mainCat ORDER By `category_id` ASC";
    $row = $regionId;
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    
    if($count > 0){
        while($rs = mysqli_fetch_array($query)){
            $row = $row . "," . $rs['category_id'];
        }
    }
    return $row;
}

function getSdCount($rowHq,$fromDate,$toDate,$productId){
    global $d;
    global $con;
    $count = 0;
    $from = $fromDate;
    $to = $toDate;
    $sql = "SELECT count(*) AS totalCount FROM `tbl_farmactivity` LEFT JOIN `tbl_farmer` 
            ON `tbl_farmactivity`.`farmerId` = `tbl_farmer`.`farmerId` WHERE `SD_date` 
            BETWEEN '$fromDate' AND '$toDate' AND `tbl_farmer`.`farmerRegion` IN ($rowHq)
            AND `tbl_farmactivity`.`productId` = '$productId'";
            
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}

function getSdvCount($rowHq,$fromDate,$toDate,$productId){
    global $d;
    global $con;
    $count = 0;
    $from = $fromDate;
    $to = $toDate;
    $sql = "SELECT count(*) AS totalCount FROM `tbl_farmactivity` LEFT JOIN `tbl_farmer` 
            ON `tbl_farmactivity`.`farmerId` = `tbl_farmer`.`farmerId` WHERE `SDV_date` 
            BETWEEN '$fromDate' AND '$toDate' AND `tbl_farmer`.`farmerRegion` IN ($rowHq)
            AND `tbl_farmactivity`.`productId` = '$productId'";
            
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}

function getFdCount($rowHq,$fromDate,$toDate,$productId){
    global $d;
    global $con;
    $count = 0;
    $from = $fromDate;
    $to = $toDate;
    $sql = "SELECT count(*) AS totalCount FROM `tbl_farmactivityFD` LEFT JOIN 
            `tbl_farmer` ON `tbl_farmactivityFD`.`farmerId` = `tbl_farmer`.`farmerId` 
            WHERE `FD_date` BETWEEN '$fromDate' AND '$toDate' 
            AND `tbl_farmer`.`farmerRegion` IN ($rowHq) AND `tbl_farmactivityFD`.`productId` = '$productId'";
            
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}

function showEmpDealerProfilingPageHeader($regionName,$reportDate){
    $header .= '<h2 style="text-align:center">GAVL CONNECT</h2>';
    $header .= '<h3 style="text-align:center">PRODUCTWISE ACTIVITY REPORT</h3>';
    return $header;
}

function getEmployeeDetail($regionId){
    global $con;
    $employeeDetail = array();
    $sql = "SELECT * FROM `tbl_employee` LEFT JOIN `tbl_designation` ON `tbl_designation`.`designationId` = `tbl_employee`.`empDesignation`  WHERE `tbl_employee`.`region` IN ($regionId)";//echo "<br>";
    $result =$con->query($sql);
    while($data = $result->fetch_assoc()){
        $employeeDetail['empName'] = $data['emp_name'];
        $employeeDetail['empDesignation'] = $data['designationName'];
    }
    return $employeeDetail;
}

function showProductwisewiseCount($srNo,$unitName,$regionName,$HqName,$regionId,$regionIds,$fromDate,$toDate){
    global $con;
    $productId = '86';
    
    $empDetail = getEmployeeDetail($regionId);
    $printTable .= "<tr>";
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$srNo .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$unitName .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$regionName .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$HqName .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$empDetail['empName'] .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$empDetail['empDesignation'] .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getSdCount($regionIds,$fromDate,$toDate,$productId).'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getSdvCount($regionIds,$fromDate,$toDate,$productId).'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getFdCount($regionIds,$fromDate,$toDate,$productId).'</td>';
    
    $printTable .= "</tr>";
    //echo $printTable;
    return $printTable;
}


function showEmpTabelHeader($regionName,$reportDate){
    global $con;
    
    $printTable .= '<h3 style="text-align:center">'.$regionName.' REGION</h3>';
    $printTable .= '<h3 style="text-align:center">'.$reportDate.'</h3>';
    $printTable .= '<table style = "font-family: Arial, Helvetica, sans-serif; border-collapse: collapse; width: 100%;">
        <thead>
            <tr>
                <th colspan="6" style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">'.$regionName.' </th>
                <th colspan="3" style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">GRACIA</th>
            </tr>    
            <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Sr.No</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Zone Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Region Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Hq Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Incharge Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Designation</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">SD</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">SDV</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">FD</th>
                ';
                $printTable .= '
            </tr>
        </thead>
    <tbody>';
    return $printTable;
}

function showEmpTabelFooter(){
    $printTable = "</tbody></table>";
    return $printTable;
}

?>