<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "../config.php";
require_once "../getRegionList.php";
    
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203; 

$updateMsg = "You are not updated ! Sync required";
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
$empId = htmlspecialchars(strip_tags($data["empId"]));
$response = array();

$supportTicketarray = array();

if (!empty($empId)) {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $regionId = htmlspecialchars(strip_tags($data["empRegionId"]));
    $status = htmlspecialchars(strip_tags($data["Ticket_Status"]));

    $pageSize = 100;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId'";
    $query1 = mysqli_query($con,$sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];

    $eid = getEmployeeId($region);
    
    $sql = "SELECT *,
        (SELECT `emp_name` FROM `tbl_employee` WHERE `id`=ss.Emp_id) as empName 
        FROM 
        `tbl_supportTkt` as ss 
        WHERE 
        ss.Emp_id IN ($eid)
        AND
        ss.Ticket_Status = '$status'
        LIMIT $limitFrom,$pageSize ";
        
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);

    if($query){
        if($rowCount > 0){
           	while ($row= mysqli_fetch_array($query)) {
           	    
           	    array_push($supportTicketarray,array( 
				    "supportTicketId" => $row["id"],
					"Subject" => $row["Subject"],
                    "empName" => $row["empName"],
                    "status" => $row["Ticket_Status"],
                    "supportTicket_date_time" => date('d-m-Y h:i:s',strtotime($row['created_at']))
					)
				);
			
            }
            $response['supportTicketList'] = $supportTicketarray;
            $response['listCount'] = $rowCount;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        }else{
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    }else{
        $response['error'] = true;
        $response['status'] = $noDataFoundcode;
        $response['message'] = $noDataFoundMsg;
    }
}else{
        $response['error'] = true;
        $response['status'] = 301;
        $response['message'] = "Feild missing";
}
echo json_encode($response);

?>