<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "../config.php";
require_once "../getRegionList.php";
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required"; 
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
$empId = htmlspecialchars(strip_tags($data["empId"]));

$response = array();
$leaveArray = array();

if (!empty($empId)) {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $empId = htmlspecialchars(strip_tags($data["empId"]));

    $pageSize = 100;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    $rowCount = 0;
 
    $sql = "SELECT * 
            FROM
            `tbl_leave_application` t1
            LEFT JOIN 
            `tbl_employee` t2
            ON
            t2.`id` = t1.`emp_id`
            LEFT JOIN 
            `tbl_leave_type` t3
            ON
            t3.`leave_type_id` = t1.`leave_type_id`
            WHERE 
            `emp_id`='$empId' 
            ORDER BY `leave_id` DESC
            LIMIT
            $limitFrom, $pageSize";
            
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                
                array_push(
                    $leaveArray,
                    array(
                        "leave_id" => $row["leave_id"],
                        "request_date" => $row["request_date"],
                        "leave_from" => $row["leave_from"],
                        "leave_upto" => $row["leave_upto"],
                        "total_days" => $row["total_days"],
                        "leave_reason" => $row["leave_reason"],
                        "leave_type_id" => $row["leave_type_id"],
                        "leave_status" => $row["leave_status"]
                    )
                );
               
            }
            $response['listCount'] = $rowCount;
            $response['leavelist'] = $leaveArray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);