<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "../config.php";
require_once "../getRegionList.php";
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required"; 
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
$empId = htmlspecialchars(strip_tags($data["empId"]));

$response = array();
$Testiarray = array();
$Farmerarray = array();

if (!empty($empId)) {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $empId = htmlspecialchars(strip_tags($data["empId"]));

    $pageSize = 100;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId'";
    $query1 = mysqli_query($con,$sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
   
    $row = getRegionList($region);
 
    $sql = "SELECT * 
            FROM 
            `tbl_testimonial` t1
            LEFT JOIN
            `tbl_testimonial_type` t2
            ON
            t1.testMeetingTypeId = t2.testimonial_type_id
            WHERE 
            `regionId` IN ($row) 
            ORDER BY 
            `testId` DESC
            LIMIT
            $limitFrom, $pageSize";
            
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                
                if ($row['testCustTypeId'] == '1') {
                    $sql12 = "SELECT * FROM `tbl_farmer` WHERE `farmerId`='" . $row['customerId'] . "'";
                    $query12 = mysqli_query($con,$sql12);
                    $row12 = mysqli_fetch_array($query12);

                    $customerName = $row12['farmerName'];
                    $customerMobile = $row12['farmerMobile'];
                } else if ($row['testCustTypeId'] == '2' || $row['testCustTypeId'] == '3') {

                    $sql13 = "SELECT * FROM `tbl_agency` WHERE `agencyId`='" . $row['customerId'] . "'";
                    $query13 = mysqli_query($con,$sql13);
                    $row13 =  mysqli_fetch_array($query13);

                    $customerName = $row13['agencyShopName'];
                    $customerMobile = $row13['agencyMobile'];
                }

                
                array_push($Testiarray, array(
                    "testId" => $row['testId'],
                    "type" => $row['testimonial_type_name'],
                    "cropId" => $row['cropId'],
                    "productId" => $row['productId'],
                    "customerId" => $row['customerId'],
                    "customerName" => $customerName,
                    "customermobile" => $customerMobile,
                    "datofSowing" => $row['datofSowing'],
                    "dateOfSpray" => $row['dateOfSpray'],
                    "empId" => $row['empId'],
                    "testPhoto" => $row['testPhoto'],
                    "testVdo" => $row['testVdo'],
                    "testMeetingTypeId" => $row['testMeetingTypeId'],
                    "testCustTypeId" => $row['testCustTypeId'],
                    "accompainedBy" => $row['accompainedBy'],
                    "testRemark" => $row['testRemark'],
                    "regionId" => $row['regionId'],
                    "activity_time" => $row['activity_time'],
                    "date" => $row['testDate']
                ));
               
            }
            $response['listCount'] = $rowCount;
            $response['testimonialList'] = $Testiarray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);