<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "../config.php";
require_once "../getRegionList.php";
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required"; 
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
$empId = htmlspecialchars(strip_tags($data["empId"]));

$response = array();
$fdArray = array(); 
$Farmerarray = array();

$fdDeleteList = array();
$fdIdArray = array();
$fdServerIdArray = array();

if (!empty($empId)) {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $regionId = htmlspecialchars(strip_tags($data["empRegionId"]));
    $approvestatus = htmlspecialchars(strip_tags($data["approvestatus"]));
    
    $pageSize = 100;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId'";
    $query1 = mysqli_query($con,$sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
   
    $row = getRegionList($region);
    if($approvestatus != ''){
        $sql = "SELECT * 
                FROM
                `tbl_farmactivityFD` t1
                LEFT JOIN 
                `tbl_employee` t2
                ON
                t2.`id` = t1.`empId`
                LEFT JOIN 
                `tbl_farmer` t3
                ON
                t3.`farmerId` = t1.`farmerId`
                LEFT JOIN 
                `tbl_crop` t4
                ON
                t4.`cropId` = t1.`cropId`
                LEFT JOIN 
                `tbl_product` t5
                ON
                t5.`pid` = t1.`productId`
                WHERE 
                t3.`farmerRegion` IN ($row) 
                AND 
                t1.`approvstatus` = '$approvestatus'
                ORDER BY 
                t1.`fafdId` DESC
                LIMIT
                $limitFrom, $pageSize";
    }else{
        $sql = "SELECT * 
                FROM
                `tbl_farmactivityFD` t1
                LEFT JOIN 
                `tbl_employee` t2
                ON
                t2.`id` = t1.`empId`
                LEFT JOIN 
                `tbl_farmer` t3
                ON
                t3.`farmerId` = t1.`farmerId`
                LEFT JOIN 
                `tbl_crop` t4
                ON
                t4.`cropId` = t1.`cropId`
                LEFT JOIN 
                `tbl_product` t5
                ON
                t5.`pid` = t1.`productId`
                WHERE 
                t3.`farmerRegion` IN ($row) 
                ORDER BY 
                t1.`fafdId` DESC
                LIMIT
                $limitFrom, $pageSize";
    }      
    // echo $sql;
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                
                $sql11 = "SELECT * FROM tbl_category WHERE category_id = '" . $row["farmerRegion"] . "'";
                $query11 = mysqli_query($con,$sql11);
                $results11 = mysqli_fetch_object($query11);

                if ($results11) {
                    $category_name = $results11->category_name;
                } else {
                    $category_name = "";
                }

                array_push(
                    $fdArray,
                    array(
                        "fafdId" => $row["fafdId"],
                        "farmerId" => $row["farmerId"],
                        "farmerName" => $row["farmerName"],
                        "farmerMobile" => $row["farmerMobile"],
                        "farmerRegion" => $category_name,
                        "fdDate" => $row["FD_date"],
                        "FD_Req_Date" => $row["FD_Req_Date"],
                        "activity_time" => $row["activity_time"],
                        "cropName" => $row["cropName"],
                        "productName" => $row["productName"],
                        "approvstatus" => $row["approvstatus"],
                        "empId" => $row['empId'],
                        "empName" => $row['emp_name']
                    )
                );            }
            $response['listCount'] = $rowCount;
            $response['FDlist'] = $fdArray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);