<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "config.php";
require_once "getRegionList.php";

$response = array();
$data1 = array();
$agency = array();

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";

$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";

$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";

$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access teminated !";

$data = json_decode(file_get_contents("php://input"), true);
if (!empty($data["regionID"])) {
    $regionID = htmlspecialchars(strip_tags($data["regionID"]));
    $empID = htmlspecialchars(strip_tags($data["empID"]));

    $row = getRegionList($regionID);

    $sql1 = "SELECT * FROM `tbl_employee` WHERE `region` IN ($row)";
    $query1 = mysqli_query($con,$sql1);

    if ($query1) {
        $count1 = mysqli_num_rows($query1);
    } else {
        die(mysqli_error());
        http_response_code(503);
    }

    if ($count1 > 0) {
        while ($row = mysqli_fetch_array($query1)) {
            array_push(
                $data1,
                array(
                    "id" => $row["id"],
                    "eid" => $row["eid"],
                    "empname" => $row["emp_name"],
                    "empmobile" => $row["emp_mobile"],
                    "empemail" => $row["emp_email"],
                    "phone" => $row["phone"],
                    "villages" => $row["villages"],
                    "distributors" => $row["distributors"]
                )
            );
        }
        $response['status'] = $SuccessStatusCode;
        $response['message'] = $SuccessStatusMsg;
        $response['falist'] = $data1;
        http_response_code(200);
    } else {
        http_response_code(200);
        $response['status'] = $noDataFoundcode;
        $response['message'] = $noDataFoundMsg;
    }
    
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);
