<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "config.php";
$response = array();
$data_target = array();
$data_achieved = array();

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successfully Data Found !";

$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access teminated !";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["regionId"]) && !empty($data["empId"])) {
    $regionId = htmlspecialchars(strip_tags($data["regionId"]));
    $empId = htmlspecialchars(strip_tags($data["empId"]));
    
    $currentDate = date('Y-m-d');
    $currentDay = date('d');
    $currentMonth = date('m');
    $currentYear = date('Y');
    $compareDate = $currentYear."-".$currentMonth."-21";
    
    if(date('Y-m-d') >= $compareDate){
        $date_from = date('Y-m-d', strtotime($compareDate));
        $date_to = date('Y-m-d', strtotime($compareDate . ' +1 month -1 day'));
    }else{
        $date_from = date('Y-m-d', strtotime($compareDate . ' -1 month'));
        $date_to = date('Y-m-d', strtotime($compareDate .'-1 day'));
    }
    
    $date_from_name = "21 " .date('F', strtotime($date_from));
    $date_to_name = "20 " .date('F', strtotime($date_to));
    
    $count_target = 0;
    
    $dateTime_from = $date_from . " 00:00:01";
    $dateTime_to = $date_to . " 23:59:59";
    
    $sql_target= "SELECT * FROM `tbl_activity_target` 
        WHERE 
        `empId` = $empId 
        AND 
        `date_from` = '$date_from' 
        AND 
        `date_to` = '$date_to'";
    $query_target = mysqli_query($con, $sql_target);
    if ($query_target) {
        $count_target = mysqli_num_rows($query_target);
    } else {
        die(mysqli_error());
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
        http_response_code(200);
    }

    if ($count_target > 0) {
        while ($row = mysqli_fetch_array($query_target)) {
            array_push(
                $data_target,
                array(
                    "ic_target" => $row["icTarget"],
                    "sd_target" => $row["sdTarget"],
                    "fd_target" => $row["fdTarget"],
                    "ofm_target" => $row["organisedMeetingTarget"],
                    "gfm_target" => $row["groupMeetingTarget"],
                    "av_target" => $row["avTarget"]
                )
            );
        }
    } else {
        array_push(
            $data_target,
            array(
                "ic_target" => 0,
                "sd_target" => 0,
                "fd_target" => 0,
                "ofm_target" => 0,
                "gfm_target" => 0,
                "av_target" => 0
            )
        );
    }
    
    // IC
    $count_achieved_ic = 0;
    $totalIC = 0;
    $sql_achieved_ic = "SELECT  
        count(DISTINCT(farmerMobile)) as ic_achieved
        FROM 
        `tbl_farmer` 
        WHERE 
        `empId` = '$empId' 
        AND 
        `farmerRegDate` BETWEEN '$date_from' AND '$date_to'";
    $query_achieved_ic = mysqli_query($con, $sql_achieved_ic);
    if ($query_achieved_ic) {
        $count_achieved_ic = mysqli_num_rows($query_achieved_ic);
        if($count_achieved_ic > 0){
            $row_achieved_ic = mysqli_fetch_array($query_achieved_ic);
            $totalIC = $row_achieved_ic['ic_achieved'];
        }else{
            $totalIC = 0;
        }
    } else {
        $totalIC = 0;
    }
    
    
    //Reisit
    $totalRevisit = 0;
    $count_achieved_revisit = 0;
    $sql_achieved_revisit = "SELECT  
        count(rid) as revisit_achieved
        FROM 
        `tbl_revisit` 
        WHERE 
        `empId` = '$empId' 
        AND 
        `revisit_datetime` BETWEEN '$dateTime_from' AND '$dateTime_to'";
    $query_achieved_revisit = mysqli_query($con, $sql_achieved_revisit);
    if ($query_achieved_revisit) {
        $count_achieved_revisit = mysqli_num_rows($query_achieved_revisit);
        if($count_achieved_revisit > 0){
            $row_achieved_revisit = mysqli_fetch_array($query_achieved_revisit);
            $totalRevisit = $row_achieved_revisit['revisit_achieved'];
        }else{
            $totalRevisit = 0;
        }
    } else {
        $totalRevisit = 0;
    }
    

    //SD
    $count_achieved_sd = 0;
    $totalSD = 0;
    $sql_achieved_sd = "SELECT  
        count(*) as sd_achieved
        FROM 
        `tbl_farmactivity` 
        WHERE 
        `empId` = '$empId' 
        AND 
        `SD_date` BETWEEN '$date_from' AND '$date_to'";
    $query_achieved_sd = mysqli_query($con, $sql_achieved_sd);
    if ($query_achieved_sd) {
        $count_achieved_sd = mysqli_num_rows($query_achieved_sd);
        if($count_achieved_sd > 0){
            $row_achieved_sd = mysqli_fetch_array($query_achieved_sd);
            $totalSD = $row_achieved_sd['sd_achieved'];
        }else{
            $totalSD = 0;
        }
    } else {
        $totalSD = 0;
    }
    
    //FD
    $count_achieved_fd = 0;
    $totalFD = 0;
    $sql_achieved_fd = "SELECT  
        count(*) as fd_achieved
        FROM 
        `tbl_farmactivityFD` 
        WHERE 
        `empId` = '$empId' 
        AND 
        `FD_date` BETWEEN '$date_from' AND '$date_to'";
    $query_achieved_fd = mysqli_query($con, $sql_achieved_fd);
    if ($query_achieved_fd) {
        $count_achieved_fd = mysqli_num_rows($query_achieved_fd);
        if($count_achieved_fd > 0){
            $row_achieved_fd = mysqli_fetch_array($query_achieved_fd);
            $totalFD = $row_achieved_fd['fd_achieved'];
        }else{
            $totalFD = 0;
        }
    } else {
        $totalFD = 0;
    }
    
    //OFM
    $count_achieved_ofm = 0;
    $totalOFM = 0;
    $sql_achieved_ofm = "SELECT  
        count(*) as ofm_achieved
        FROM 
        `tbl_farmermeeting` 
        WHERE 
        `empId` = '$empId' 
        AND
        `fmType` IN ('1','3')
        AND 
        `fmDate` BETWEEN '$date_from' AND '$date_to'";
    $query_achieved_ofm = mysqli_query($con, $sql_achieved_ofm);
    if ($query_achieved_ofm) {
        $count_achieved_ofm = mysqli_num_rows($query_achieved_ofm);
        if($count_achieved_ofm > 0){
            $row_achieved_ofm = mysqli_fetch_array($query_achieved_ofm);
            $totalOFM = $row_achieved_ofm['ofm_achieved'];
        }else{
            $totalOFM = 0;
        }
    } else {
        $totalOFM = 0;
    }
    
    //GFM
    $count_achieved_gfm = 0;
    $totalGFM = 0;
    $sql_achieved_gfm = "SELECT  
        count(*) as gfm_achieved
        FROM 
        `tbl_farmermeeting` 
        WHERE 
        `empId` = '$empId' 
        AND
        `fmType` IN ('2','4')
        AND 
        `fmDate` BETWEEN '$date_from' AND '$date_to'";
    $query_achieved_gfm = mysqli_query($con, $sql_achieved_gfm);
    if ($query_achieved_gfm) {
        $count_achieved_gfm = mysqli_num_rows($query_achieved_gfm);
        if($count_achieved_gfm > 0){
            $row_achieved_gfm = mysqli_fetch_array($query_achieved_gfm);
            $totalGFM = $row_achieved_gfm['gfm_achieved'];
        }else{
            $totalGFM = 0;
        }
    } else {
        $totalGFM = 0;
    }
    
    //AV
    $count_achieved_av = 0;
    $totalAV = 0;
    $sql_achieved_av = "SELECT  
        count(*) as av_achieved
        FROM 
        `tbl_agencyvisit` 
        WHERE 
        `empId` = '$empId'
        AND 
        `visitDate` BETWEEN '$date_from' AND '$date_to'";
    $query_achieved_av = mysqli_query($con, $sql_achieved_av);
    if ($query_achieved_av) {
        $count_achieved_av = mysqli_num_rows($query_achieved_av);
        if($count_achieved_av > 0){
            $row_achieved_av = mysqli_fetch_array($query_achieved_av);
            $totalAV = $row_achieved_av['av_achieved'];
        }else{
            $totalAV = 0;
        }
    } else {
        $totalAV = 0;
    }
    
    $totalIC = $totalIC + $totalRevisit;
    array_push(
        $data_achieved,
        array(
            "ic_achieved" => $totalIC,
            "sd_achieved" => $totalSD,
            "fd_achieved" => $totalFD,
            "ofm_achieved" => $totalOFM,
            "gfm_achieved" => $totalGFM,
            "av_achieved" => $totalAV
        )
    );
        
    

    $response['targets'] = $data_target;
    $response['achievements'] = $data_achieved;
    $response['empId'] = $empId;
    $response['from_date'] = $date_from;
    $response['to_date'] = $date_to;
    $response['appMsg'] = "Activity targets achieved between \n" .$date_from_name ." to " .$date_to_name ;
    $response['status'] = $SuccessStatusCode;
    $response['message'] = $SuccessStatusMsg;
    http_response_code(200);
}else{
    $response['status'] = $unauthorisedUserCode;
    $response['message'] = $unauthorisedUserMsg;
    http_response_code(403);
}

echo json_encode($response);
