<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "config.php";
$response = array();
$data1 = array();
$agency = array();

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Agency registered successfully !";

$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";

$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";

$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access teminated !";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["agencyRegion"]) && !empty($data["empId"])) {
    $agencyRegion = htmlspecialchars(strip_tags($data["agencyRegion"]));
    $empId = htmlspecialchars(strip_tags($data["empId"]));
    $agencyType = htmlspecialchars(strip_tags($data["agencyType"]));

    
    $count = 1;
    if ($count > 0) {

        require_once "getRegionList.php";
        $row = getRegionList($agencyRegion);

        $sql1 = "SELECT * 
                FROM 
                `tbl_agencyvisit` 
                LEFT JOIN `tbl_agency` ON 
		        tbl_agencyvisit.agencyId = tbl_agency.agencyId 
                WHERE 
		        `tbl_agencyvisit`.agencyRegion IN ($row) 
                AND 
                `tbl_agencyvisit`.agencyType = '$agencyType'";

        $query1 = mysqli_query($con,$sql1);
        if ($query1) {
            $count1 = mysqli_num_rows($query1);
        } else {
            die(mysqli_error());
            http_response_code(503);
        }

        if ($count1 > 0) {
            while ($row = mysqli_fetch_array($query1)) {
                array_push(
                    $data1,
                    array(
                        "visitId" => $row["visitId"],
                        "visitDate" => $row["visitDate"],
                        "activity_time" => $row["activity_time"],
                        "agencyId" => $row["agencyId"],
                        "agencyName" => $row["agencyName"],
                        "agencyMobile" => $row["agencyMobile"],
                        "agencyCity" => $row["agencyCity"],
                        "cropUpdate" => $row["cropUpdate"],
                        "liquidation" => $row["liquidation"],
                        "feedback" => $row["feedback"],
                        "collecttion" => $row["collecttion"],
                        "postHarvest" => $row["postHarvest"],
                        "accompanedBy" => $row["accompanedBy"],
                        "empId" => $row["empId"],
                        "latlong" => $row["latlong"],
                        "agencyRegion" => $row["agencyRegion"],
                    )
                );
                $agency[] = $data1;
            }
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            $response['detail'] = $data1;
            http_response_code(200);
        } else {
            http_response_code(400);
            $response['status'] =   $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);
