<?php
// error_reporting(1);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "getRegionList.php";
require_once "config.php";
include("Message.php");
include 'sendSms.php';

$response = array();
$product = array();
$empDetails = array();


$SuccessStatusCode = 200;
$SuccessStatusMsg = "' Successful !"; 
$FailStatusCode = 202;
$FailStatusMsg = "Request unable to complete !";
$row = getRegionList(1);
$getRegionNameVal = getRegionName($row);
$getDesignationNameArrayVal = getDesignationNameArray();
$getEmployeeNameArrayVal = getEmployeeNameArray();
// exit;
// print_r($getDesignationNameArrayVal);
$data = json_decode(file_get_contents("php://input"), true);
$empRegion = htmlspecialchars(strip_tags($data["empRegion"]));
$empId = htmlspecialchars(strip_tags($data["empId"]));
$action = htmlspecialchars(strip_tags($data["action"]));
$accessTokenKey = htmlspecialchars(strip_tags($data["accessTokenKey"]));


if (($empRegion != '' || $empRegion != 'null' || $empRegion != null) && $accessTokenKey == 'Sjh5767gvghvhnhDdfgF') {
    $rid = $empRegion;
    $searchRegion = $empRegion;
    if($action == 'list'){
        $row =$rid.','.getRegionList($empRegion);
        $sql1 = "SELECT * 
            FROM 
            `tbl_employee` 
            WHERE 
            `region` IN ($row) 
            AND 
            `deleteFlag` = '0' 
            AND 
            `deactivteRequestFlag` IN (0,3) 
            AND 
            `empDesignation` NOT IN (1,2,3,18,19,20,21,22,24,25,27,28,29)";
        $query1 = mysqli_query($con, $sql1);
        $empCount = mysqli_num_rows($query1);
        while ($row = mysqli_fetch_array($query1)) {
            $designationName = '';
            if($row['empDesignation']){
                $key = '';
                $key = array_search($row['empDesignation'], array_column($getDesignationNameArrayVal, 'designationId'));
                if ($key === FALSE) {
                    $designationName = '';
                } else {
                    $designationName = $getDesignationNameArrayVal[$key]['designationName'];
                }
            }
            $regionName = '';
            if($row['region']){
                $key = '';
                $key = array_search($row['region'], array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $regionName = '';
                } else {
                    $regionName = $getRegionNameVal[$key]['category_name'];
                }
            }
            array_push(
                $empDetails,
                array(
                    "empId" => $row['id'],
                    "empRegion" => $regionName,
                    "empRegionId" => $row['region'],
                    "empName" => $row['emp_name'],
                    "empDegignation" => $designationName,
                    "empMobile" => $row['emp_mobile']
                )
            );
        }
        $response['empCount'] = $empCount;
        $response['empDetails'] = $empDetails;
    }
    
    if($action == 'detailList'){
        $row = $rid.','.getRegionList($empRegion);
        $sql1 = "SELECT * 
            FROM 
            `tbl_employee` 
            WHERE 
            `id` = '$empId' ";
        $query1 = mysqli_query($con, $sql1);
        $empCount = mysqli_num_rows($query1);
        while ($row = mysqli_fetch_array($query1)) {
            $designationName = '';
            if($row['empDesignation']){
                $key = '';
                $key = array_search($row['empDesignation'], array_column($getDesignationNameArrayVal, 'designationId'));
                if ($key === FALSE) {
                    $designationName = '';
                } else {
                    $designationName = $getDesignationNameArrayVal[$key]['designationName'];
                }
            }
            $regionName = '';
            if($row['region']){
                $key = '';
                $key = array_search($row['region'], array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $regionName = '';
                    $unitId = '';
                    $territoryId = '';
                    $headquarterId = '';
                } else {
                    $regionName = $getRegionNameVal[$key]['category_name'];
                    $unitId = $getRegionNameVal[$key]['unit'];
                    $territoryId = $getRegionNameVal[$key]['territory'];
                    $headquarterId = $getRegionNameVal[$key]['headquarter'];
                }
            }
            $unitName = '';
            if($unitId){
                $key = '';
                $key = array_search($unitId, array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $unitName = '';
                } else {
                    $unitName = $getRegionNameVal[$key]['category_name'];
                }
            }
            
            $territoryName = '';
            if($territoryId){
                $key = '';
                $key = array_search($territoryId, array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $territoryName = '';
                } else {
                    $territoryName = $getRegionNameVal[$key]['category_name'];
                }
            }
            $headquarterName = '';
            if($headquarterId){
                $key = '';
                $key = array_search($headquarterId, array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $headquarterName = '';
                } else {
                    $headquarterName = $getRegionNameVal[$key]['category_name'];
                }
            }
            $reportingManager = '';
            if($row['parent_empid']){
                $key = '';
                $key = array_search($row['parent_empid'], array_column($getEmployeeNameArrayVal, 'empId'));
                if ($key === FALSE) {
                    $reportingManager = '';
                } else {
                    $reportingManager = $getEmployeeNameArrayVal[$key]['empName'];
                }
            }
            array_push(
                $empDetails,
                array(
                    "EDPNo" => $row['EDP_code'],
                    "empRegion" => $regionName,
                    "empRegionId" => $row['regionId'],
                    "empName" => $row['emp_name'],
                    "empDegignation" => $designationName,
                    "empMobile" => $row['emp_mobile'],
                    "addDate" => $row['addDate'],
                    "UnitName" => $unitName,
                    "territoryName" => $territoryName,
                    "headquarteName" => $headquarterName,
                    "reportingManager" => $reportingManager
                )
            );
        }
        $response['empCount'] = $empCount;
        $response['empDetails'] = $empDetails;
    }
    
    if($action == 'deactivatedId'){
        $deactivateId = htmlspecialchars(strip_tags($data["requestDeactivetId"]));
        $deactivteRequestDate = date('Y-m-d h:i:s');
        $sql = "UPDATE tbl_employee SET deactivteRequestFlag = '1', deletedBy='$empId',deactivteRequestDate = '$deactivteRequestDate' WHERE id='$deactivateId' ";
        $result = mysqli_query($con,$sql);
        if($result){
            $response['successStatusCode'] = '200';
            $response['successStatusMessage'] = 'Request Successfully';
        }else{
            $response['successStatusCode'] = 202;
            $response['successStatusMessage'] = 'Something Went wrong!';
        }
    }
    
    if($action == 'approvedIdOPT'){
        $approvedId = htmlspecialchars(strip_tags($data["approveDeactivateId"]));
        
        $query1 = "SELECT * FROM tbl_employee WHERE `id` = '$empId' AND `deleteFlag`= 0";
        $result1 = $con->query($query1);
        $data1 = $result1->fetch_object();
        $empCount = mysqli_num_rows($result1);
        $mobileno = $data1->emp_mobile;
        $id2 = $data1->id;
        $currDateTime = date('Y-m-d H:i:s');
        if ($empCount >= 1) {
            $otp = rand(1000, 9999);
            $message = smsString_otp($otp);
            $smsString = sendSMS(urlencode($mobileno), urlencode($message), 'sendOTP');
            $json = json_decode(file_get_contents($smsString));
            $query12 = "UPDATE `tbl_employee` SET `deactivatedOtp` = '$otp',`deactivatedOtpDateTime` = '$currDateTime' WHERE `id`= '$id2'";
            mysqli_query($con, $query12);
            $sqlUpdateKey = "UPDATE `tbl_updatekeynew` SET `empList`= empList+1 WHERE `id`=1";
            $queryUpdateKey = mysqli_query($con, $sqlUpdateKey);

            $response['otp'] = $otp;
            $response['statusCode'] = 200;
            $response['statusMessage'] = "OTP Send Successfully";
        }else{
            $response['statusCode'] = 201;
            $response['statusMessage'] = "Failed";
        }
        
    }
    if($action == 'approvedIdByOTP'){
        $approvedId = htmlspecialchars(strip_tags($data["approveDeactivateId"]));
        $otp = htmlspecialchars(strip_tags($data["otp"]));
        $date = date('Y-m-d');
        $approvedeactivteRequestDate = date('Y-m-d h:i:s');
        $query1 = "SELECT * FROM tbl_employee WHERE `id` = '$empId' AND `deleteFlag`= 0";
        $result1 = $con->query($query1);
        $data1 = $result1->fetch_object();
        $mobileno = $data1->emp_mobile;
        $requestedDate = $data1->deactivteRequestDate;
        
        $query2 = "SELECT * FROM tbl_employee WHERE `eid` = '$mobileno' AND `deactivatedOtp`='$otp' AND `deleteFlag`= 0";
        $result2 = $con->query($query2);
        $data2 = $result2->fetch_object();
        $empCount1 = mysqli_num_rows($result2);
        
        if ($empCount1 >= 1) {
            $sql = "UPDATE tbl_employee SET deactivteRequestFlag = '2', approvedeactivteRequestBy='$empId',deleteDate='$requestedDate',approvedeactivteRequestDate='$approvedeactivteRequestDate' WHERE id='$approvedId' ";
            $result = mysqli_query($con,$sql);
            if($result){
                $sql1 = "UPDATE tbl_employee SET deleteFlag=1 WHERE id='$approvedId' ";
                $result1 = mysqli_query($con,$sql1);
                $response['successStatusCode'] = '200';
                $response['successStatusMessage'] = 'Approved Successfully';
            }else{
                $response['successStatusCode'] = 202;
                $response['successStatusMessage'] = 'Something Went wrong!';
            }
        }else{
            $response['statusCode'] = 201;
            $response['statusMessage'] = "Failed! Incorrect OTP";
        }
    }
    
    if($action == 'rejectId'){
        $rejectId = htmlspecialchars(strip_tags($data["rejectDeactivateId"]));
        $rejectdeactivteRequestDate = date('Y-m-d h:i:s');
        $sql = "UPDATE tbl_employee SET deactivteRequestFlag = '3',rejectdeactivteRequestBy='$empId',rejectdeactivteRequestDate='$rejectdeactivteRequestDate' WHERE id='$rejectId' ";
        $result = mysqli_query($con,$sql);
        if($result){
            $response['successStatusCode'] = '200';
            $response['successStatusMessage'] = 'Reject Successfully';
        }else{
            $response['successStatusCode'] = 202;
            $response['successStatusMessage'] = 'Something Went wrong!';
        }
    }
    
    if($action == 'pendingList'){
        $row =$rid.','.getRegionList($empRegion);
        $sql1 = "SELECT * 
            FROM 
            `tbl_employee` 
            WHERE 
            `region` IN ($row) 
            AND 
            `deleteFlag` = '0' 
            AND 
            `deactivteRequestFlag` = '1' 
            AND 
            `empDesignation` NOT IN (1,2,3,18,19,20,21,22,24,25,27,28,29)";
        $query1 = mysqli_query($con, $sql1);
        $empCount = mysqli_num_rows($query1);
        while ($row = mysqli_fetch_array($query1)) {
            $designationName = '';
            if($row['empDesignation']){
                $key = '';
                $key = array_search($row['empDesignation'], array_column($getDesignationNameArrayVal, 'designationId'));
                if ($key === FALSE) {
                    $designationName = '';
                } else {
                    $designationName = $getDesignationNameArrayVal[$key]['designationName'];
                }
            }
            $regionName = '';
            if($row['region']){
                $key = '';
                $key = array_search($row['region'], array_column($getRegionNameVal, 'category_id'));
                if ($key === FALSE) {
                    $regionName = '';
                } else {
                    $regionName = $getRegionNameVal[$key]['category_name'];
                }
            }
            array_push(
                $empDetails,
                array(
                    "empId" => $row['id'],
                    "empRegionId" => $row['region'],
                    "empRegion" => $regionName,
                    "empName" => $row['emp_name'],
                    "empDegignation" => $designationName,
                    "empMobile" => $row['emp_mobile']
                )
            );
        }
        $response['empCount'] = $empCount;
        $response['empDetails'] = $empDetails;
    }
    
    $response['status'] = $SuccessStatusCode;
    $response['message'] = $SuccessStatusMsg;
    http_response_code(200);
} else {
    $response['status'] = "Failed";
    $response['message'] = "Region Name Missing !";
    http_response_code(404);
}
echo json_encode($response);
