<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "config.php";
$response = array();
$data1 = array();
$regions = array();

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Agency registered successfully !";

$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";

$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";

$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access teminated !";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["aType"]) && !empty($data["empId"])) {
    $empId = htmlspecialchars(strip_tags($data["empId"]));
    $agencyType = htmlspecialchars(strip_tags($data["aType"]));

    $aServerId = str_replace("#", ",", $data["aServerId"]);
    if (empty($aServerId)) {
        $aServerIdArray = [];
    } else {
        $aServerIdArray = explode(",", $aServerId);
    }

    $sql = "SELECT * FROM tbl_employee WHERE `id` = '$empId'";
    $query = mysqli_query($con, $sql);
    $rs = mysqli_fetch_object($query);
    if ($query) {
        $count = mysqli_num_rows($query);
        $desgination = $rs->empDesignation;
        $agencyRegion = $rs->region;
    } else {
        die(mysqli_error());
        http_response_code(503);
    }

    $count = 1;
    if ($count > 0) {
        require_once "getRegionList.php";
        $row = getRegionList($agencyRegion);

        $sql1 = "SELECT * 
            FROM 
            `tbl_agency` 
            LEFT JOIN 
            `tbl_category` 
            ON 
            `tbl_agency`.`agencyRegion` = `tbl_category`.`category_id` 
            WHERE 
            `agencyRegion` IN ($row) 
            AND 
            `agencyType` = '$agencyType'";
        $query1 = mysqli_query($con, $sql1);
        if ($query1) {
            $count1 = mysqli_num_rows($query1);
        } else {
            die(mysqli_error());
            http_response_code(503);
        }
        $rowCount = 0;
        if ($count1 > 0) {
            while ($row = mysqli_fetch_array($query1)) {
                $agencyIdArray[] = $row["agencyId"];
                if (in_array($row["agencyId"], $avServerIdArray)) {
                } else {
                    $rowCount = $rowCount + 1;
                    array_push(
                        $data1,
                        array(
                            "agencyId" => $row["agencyId"],
                            "agencyShopName" => $row["agencyShopName"],
                            "agencyName" => $row["agencyName"],
                            "agencyMobile" => $row["agencyMobile"],
                            "agencyAltNumber" => $row["agencyAltNumber"],
                            "agencyLocation" => $row["agencyLocation"],
                            "agencyAddress" => $row["agencyAddress"],
                            "agencyCity" => $row["agencyCity"],
                            "agencyPincode" => $row["agencyPincode"],
                            "regionName" => $row["category_name"],
                            "agencyRegion" => $row["agencyRegion"],
                            "agencyType" => $row["agencyType"],
                            "activity_time" => $row["activity_time"],
                            "agencyDistributor" => $row["agencyDistributor"],
                            "agencyDetailId" => $row["agencyDetailId"],
                            "activity_time" => $row["activity_time"]
                        )
                    );
                }
            }

            $sql13 = "SELECT * FROM `tbl_updatekeynew`";
            $query13 = mysqli_query($con, $sql13);
            $results13 = mysqli_fetch_object($query13);
            $response['updatekey'] = $results13->distributorlist;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            $response['agencyList'] = $data1;
            $response['rowCount'] = $rowCount;

            $agencyDeleteList = array_values(array_diff($aServerIdArray, $agencyIdArray));

            if (empty($agencyDeleteList)) {
                $response['agencyDeleteList'] = [];
            } else {
                $response['agencyDeleteList'] = $agencyDeleteList;
            }
            http_response_code(200);
        } else {
            $response['status'] =   $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);
