<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "config.php";
$response = array();
$data_target = array();
$data_achieved = array();

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successfully Data Found !";

$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access teminated !";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["regionId"]) && !empty($data["empId"])) {
    $regionId = htmlspecialchars(strip_tags($data["regionId"]));
    $empId = htmlspecialchars(strip_tags($data["empId"]));
    
    $currentDate = date('Y-m-d');
    $currentDay = date('d');
    $currentMonth = date('m');
    $currentYear = date('Y');
    $compareDate = $currentYear."-".$currentMonth."-21";
    
    if(date('Y-m-d') >= $compareDate){
        $date_from = date('Y-m-d', strtotime($compareDate));
        $date_to = date('Y-m-d', strtotime($compareDate . ' +1 month -1 day'));
    }else{
        $date_from = date('Y-m-d', strtotime($compareDate . ' -1 month'));
        $date_to = date('Y-m-d', strtotime($compareDate .'-1 day'));
    }
    
    $date_from_name = "21 " .date('F', strtotime($date_from));
    $date_to_name = "20 " .date('F', strtotime($date_to));
    
    $count_target = 0;

    
    $sql_target= "SELECT * FROM `tbl_activity_target` 
        WHERE 
        `empId` = $empId 
        AND 
        `date_from` = '$date_from' 
        AND 
        `date_to` = '$date_to'";
    $query_target = mysqli_query($con, $sql_target);
    if ($query_target) {
        $count_target = mysqli_num_rows($query_target);
    } else {
        die(mysqli_error());
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
        http_response_code(200);
    }

    if ($count_target > 0) {
        while ($row = mysqli_fetch_array($query_target)) {
            array_push(
                $data_target,
                array(
                    "ic_target" => $row["icTarget"],
                    "sd_target" => $row["sdTarget"],
                    "fd_target" => $row["fdTarget"],
                    "ofm_target" => $row["organisedMeetingTarget"],
                    "gfm_target" => $row["groupMeetingTarget"],
                    "av_target" => $row["avTarget"]
                )
            );
        }
    } else {
        array_push(
            $data_target,
            array(
                "ic_target" => 0,
                "sd_target" => 0,
                "fd_target" => 0,
                "ofm_target" => 0,
                "gfm_target" => 0,
                "av_target" => 0
            )
        );
    }
    
    $count_achieved = 0;
    $sql_achieved = "SELECT empId, 
        sum(`ic`) as ic_achieved,
        sum(`revisit`) as revisit_achieved,
        sum(`sd`) as sd_achieved,
        sum(`fd`) as fd_achieved,
        sum(`ofm`) as ofm_achieved,
        sum(`gfm`) as gfm_achieved,
        sum(`av`) as av_achieved
        FROM 
        `tbl_activity_count_current_year` 
        WHERE 
        `empId` = '$empId' 
        AND 
        `activityDate` BETWEEN '$date_from' AND '$date_to'";
    $query_achieved = mysqli_query($con, $sql_achieved);
    if ($query_achieved) {
        $count_achieved = mysqli_num_rows($query_achieved);
    } else {
        die(mysqli_error());
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
        http_response_code(200);
    }

    if ($count_achieved > 0) {
        while ($row_achieved = mysqli_fetch_array($query_achieved)) {
            $totalIC = 0;
            $totalIC = $row_achieved["ic_achieved"] + $row_achieved["revisit_achieved"];
            array_push(
                $data_achieved,
                array(
                    "ic_achieved" => ($totalIC === NULL) ? 0 : $totalIC,
                    "sd_achieved" => ($row_achieved["sd_achieved"] === NULL) ? 0 : $row_achieved["sd_achieved"],
                    "fd_achieved" => ($row_achieved["fd_achieved"] === NULL) ? 0 : $row_achieved["fd_achieved"],
                    "ofm_achieved" => ($row_achieved["ofm_achieved"] === NULL) ? 0 : $row_achieved["ofm_achieved"],
                    "gfm_achieved" => ($row_achieved["gfm_achieved"] === NULL) ? 0 : $row_achieved["gfm_achieved"],
                    "av_achieved" => ($row_achieved["av_achieved"] === NULL) ? 0 : $row_achieved["av_achieved"]
                )
            );
        }
    } else {
        array_push(
            $data_achieved,
            array(
                "ic_achieved" => 0,
                "sd_achieved" => 0,
                "fd_achieved" => 0,
                "ofm_achieved" => 0,
                "gfm_achieved" => 0,
                "av_achieved" => 0
            )
        );
    }

    $response['targets'] = $data_target;
    $response['achievements'] = $data_achieved;
    $response['empId'] = $empId;
    $response['from_date'] = $date_from;
    $response['to_date'] = $date_to;
    $response['appMsg'] = "Activity targets achieved between \n" .$date_from_name ." to " .$date_to_name ;
    $response['status'] = $SuccessStatusCode;
    $response['message'] = $SuccessStatusMsg;
    http_response_code(200);
}else{
    $response['status'] = $unauthorisedUserCode;
    $response['message'] = $unauthorisedUserMsg;
    http_response_code(403);
}

echo json_encode($response);
