<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "../config.php";
require_once "../getRegionList.php";
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required"; 
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
$empId = htmlspecialchars(strip_tags($data["empId"]));

$response = array();
$icarray = array();
$Farmerarray = array();

$fdDeleteList = array();
$fdIdArray = array();
$fdServerIdArray = array();
$maxVal = 0;
if (!empty($empId)) {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $regionId = htmlspecialchars(strip_tags($data["empRegionId"]));

    $pageSize = 1000;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId'";
    $query1 = mysqli_query($con,$sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
   
    $row = getRegionList($region);
 
    $sql = "SELECT * 
            FROM
            `tbl_farmer` 
            LEFT JOIN 
            `tbl_employee`
            ON
            `tbl_employee`.`id` = `tbl_farmer`.`empId`
            WHERE 
            `tbl_farmer`.`farmerRegion` IN ($row) 
            ORDER BY 
            `farmerId` DESC
            LIMIT
            $limitFrom, $limitTo";
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                
                $sql11 = "SELECT * FROM tbl_employee WHERE id = '" . $row["empId"] . "'";
                $query11 = mysqli_query($con,$sql11);
                $results11 = mysqli_fetch_object($query11);

                if ($results11) {
                    $empName = $results11->emp_name;
                } else {
                    $empName = "";
                }
                
                $sql11 = "SELECT * FROM tbl_category WHERE category_id = '" . $row["farmerRegion"] . "'";
                $query11 = mysqli_query($con,$sql11);
                $results11 = mysqli_fetch_object($query11);

                if ($results11) {
                    $category_name = $results11->category_name;
                } else {
                    $category_name = "";
                }

                array_push(
                    $icarray,
                    array(
                        "farmerId" => $row["farmerId"],
                        "farmerName" => $row["farmerName"],
                        "farmerMobile" => $row["farmerMobile"],
                        "farmerRegion" => $category_name,
                        "farmerRegDate" => $row["farmerRegDate"],
                        "activity_time" => $row["activity_time"],
                        "empId" => $empName
                    )
                );
               
            }
            $response['listCount'] = $rowCount;
            $response['IClist'] = $icarray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);