<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once "config.php";

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203; 

$updateMsg = "You are not updated ! Sync required";
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access teminated !";
$data = json_decode(file_get_contents("php://input"), true);
$empId = htmlspecialchars(strip_tags($data["empId"]));
$actionType = htmlspecialchars(strip_tags($data["actionType"]));
$action = htmlspecialchars(strip_tags($data["action"]));
$response = array();
$activityArray = array();
$Farmerarray = array();

$fdDeleteList = array();
$fdIdArray = array();
$fdServerIdArray = array();
$maxVal = 0;
if (!empty($empId) && $actionType == 'FD') {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $regionId = htmlspecialchars(strip_tags($data["empRegionId"]));

    $pageSize = 1000;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId'";
    $query1 = mysqli_query($con,$sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
    
    if($action == 'fdCompleted'){
        $approvalStatus = "'1','2','3'";
    }else{
        $approvalStatus = "'0'";
    }

    require_once "getRegionList.php";
    $row = getRegionList($region);

    $sql = "SELECT 
        `tbl_farmactivityFD`.`fafdId`,
        `tbl_farmactivityFD`.`FD_Req_Date`,
        `tbl_farmactivityFD`.`farmerId`,
        `tbl_farmer`.`farmerName`,
        `tbl_crop`.`cropName`,
        `tbl_product`.`productName`,
        `tbl_employee`.`emp_name`
        FROM 
        `tbl_farmactivityFD` 
        LEFT JOIN 
        `tbl_farmer` 
        ON 
        `tbl_farmactivityFD`.`farmerId` = `tbl_farmer`.farmerId 
        LEFT JOIN 
        `tbl_crop` 
        ON 
        `tbl_crop`.`cropId` = `tbl_farmactivityFD`.`cropId` 
        LEFT JOIN 
        `tbl_product` 
        ON 
        `tbl_product`.`pid` = `tbl_farmactivityFD`.`productId` 
        LEFT JOIN 
        `tbl_employee`
        ON
        `tbl_employee`.`id` = `tbl_farmactivityFD`.`empId`
        WHERE 
        `tbl_farmer`.`farmerRegion` IN ($row) 
        AND 
        `tbl_farmer`.delete_flag = '0'
        AND
        `tbl_farmactivityFD`.`approvstatus` IN ($approvalStatus)
        ORDER BY 
        `fafdId` DESC
        LIMIT
        $limitFrom,$limitTo";
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                array_push($activityArray, array(
                    "FDId" => $row["fafdId"],
                    "FD_Req_Date" => $row["FD_Req_Date"],
                    "farmerId" => $row["farmerId"],
                    "farmerName" => $row["farmerName"],
                    "crop" => $row["cropName"],
                    "product" => $row["productName"],
                    "empName" => $row["emp_name"],
                ));
            }
            $response['listCount'] = $rowCount;
            $response['FDlist'] = $activityArray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
}else if (!empty($empId) && $actionType == 'FM') {
    $pageNum = htmlspecialchars(strip_tags($data["pageNum"]));
    $regionId = htmlspecialchars(strip_tags($data["empRegionId"]));

    $pageSize = 1000;
    $limitFrom = $pageNum * $pageSize;
    $limitTo = $limitFrom + $pageSize;
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId'";
    $query1 = mysqli_query($con,$sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
    
    if($action == 'fmCompleted'){
        $approvalStatus = "'1','2','3'";
    }else{
        $approvalStatus = "'0'";
    }

    require_once "getRegionList.php";
    $row = getRegionList($region);

    $sql = "SELECT 
        `tbl_farmermeeting`.`fmId`,
        `tbl_farmermeeting`.`FMReqDate`,
        `tbl_farmermeeting`.`villageNameID`,
        `tbl_employee`.`emp_name`
        FROM 
        `tbl_farmermeeting` 
        LEFT JOIN 
        `tbl_employee`
        ON
        `tbl_employee`.`id` = `tbl_farmermeeting`.`empId`
        WHERE 
        `tbl_farmermeeting`.`farmerRegion` IN ($row) 
        AND
        `tbl_farmermeeting`.`approvstatus` IN ($approvalStatus)
        AND
        `tbl_farmermeeting`.`fmType` IN ('1','3')
        ORDER BY 
        `fmId` DESC
        LIMIT
        $limitFrom,$limitTo";
    $query = mysqli_query($con,$sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                array_push($activityArray, array(
                    "FMId" => $row["fmId"],
                    "FMReqDate" => $row["FMReqDate"],
                    "villageName" => $row["villageNameID"],
                    "empName" => $row["emp_name"],
                ));
            }
            $response['listCount'] = $rowCount;
            $response['Activitylist'] = $activityArray;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            http_response_code(200);
        } else {
            http_response_code(200);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);